"""Represents a bullet coming from a turret"""

import random

import serge.actor

import common

class Bullet(serge.actor.Actor):
    """Represents a bullet"""

    def __init__(self, start, target, speed, damage, slowdown, impact_radius, sprite, board):
        """Initialise the Bullet"""
        super(Bullet, self).__init__('bullet', sprite)
        #
        self.board = board
        self.start = start
        self.target = target
        self.speed = speed
        self.damage = damage
        self.slowdown = slowdown
        self.impact_radius = impact_radius
        #
        self.setSpriteName(sprite)
        self.setLayerName('turrets')
        self.exploded = False
        
    def addedToWorld(self, world):
        """We were added to the world"""
        super(Bullet, self).addedToWorld(world)
        self.moveTo(*self.start)

    def updateActor(self, interval, world):
        """Update the bullet"""
        super(Bullet, self).updateActor(interval, world)
        #
        vector = (common.Vec2d(self.target) - common.Vec2d(self.x, self.y))
        if self.exploded:
            if not self.visual.running:
                world.removeActor(self)
                self.board.bulletLands((self.x, self.y), self, self.impact_radius)
        elif vector.length == 0:
            self.setSpriteName('fire')
            self.setAngle(random.randrange(0, 360))
            self.exploded = True
        else:
            vector.length = min(self.speed*interval/1000.0, vector.length)
            self.move(vector.x, vector.y)
        

